//
//  STPPaymentMethodCrypto.swift
//  StripePayments
//
//  Created by Eric Zhang on 11/20/24.
//

import Foundation

/// The Crypto Payment Method.
/// - seealso: https://docs.stripe.com/crypto/pay-with-crypto
public class STPPaymentMethodCrypto: NSObject {
    /// :nodoc:
    @objc private(set) public var allResponseFields: [AnyHashable: Any] = [:]

    // MARK: - Description
    /// :nodoc:
    @objc public override var description: String {
        let props = [
            // Object
            String(format: "%@: %p", NSStringFromClass(STPPaymentMethodCrypto.self), self)
        ]

        return "<\(props.joined(separator: "; "))>"
    }

    // MARK: - STPAPIResponseDecodeable
    @objc
    /// :nodoc:
    public class func decodedObject(fromAPIResponse response: [AnyHashable: Any]?) -> Self? {
        guard let response = response else {
            return nil
        }

        return self.init(dictionary: response)
    }

    required init?(dictionary dict: [AnyHashable: Any]) {
        super.init()
    }
}
